package ru.yandex.partner.core.entity;

import java.util.Set;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.core.filter.CoreFilterNode;

public interface Query<M extends ModelWithId> {

    Query<M> withProps(Set<ModelProperty<? extends Model, ?>> props);

    default Query<M> withProps(ModelProperty<?, ?>... props) {
        return withProps(Set.of(props));
    }

    Query<M> withFilter(CoreFilterNode<? super M> filter);

    Query<M> forUpdate(boolean forUpdate);

    Query<M> forUpdate();

    @NotNull
    Class<M> getClazz();

    @NotNull
    CoreFilterNode<? super M> getFilter();

    /**
     * Единственный геттер, который торчит в интерфейсе. Так как возникает потребность докидывать
     * поля на основе уже проставленных
     *
     * @return
     */
    @Nullable
    Set<ModelProperty<? extends Model, ?>> getProps();

    // в случае необходимости можно вынести сюда и другие геттеры
}
