package ru.yandex.partner.core.entity;

@FunctionalInterface
public interface UpdateLifecycle<M> {
    void beforeUpdate(M modelFromDb, M newModelState);

    default UpdateLifecycle<M> then(UpdateLifecycle<M> other) {
        var self = this;
        return (modelFromDb, newModelState) -> {
            self.beforeUpdate(modelFromDb, newModelState);
            other.beforeUpdate(modelFromDb, newModelState);
        };
    }
}
