package ru.yandex.partner.core.entity.adtype;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AdType {
    TEXT("text"), MEDIA("media"), VIDEO("video");

    private final String name;

    AdType(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public List<String> getStrategyFields() {
        return Stream.of("active", "blocked", "cpm")
                .map(postfix -> name + "_" + postfix)
                .collect(Collectors.toList());
    }
}
