package ru.yandex.partner.core.entity.agreement.service;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.block.BlockType;

@Configuration
@ConfigurationProperties("core.agreement-checker")
public class AgreementCheckerProperties {
    /**
     * Клиенты, для которых никакие продукты не приостанавливаются,
     * вне зависимости от наличия действующего/окончившегося договора в балансе
     */
    private Set<Long> specialClients = Set.of(
            // https://st.yandex-team.ru/PI-11665
            CoreConstants.ADINSIDE_CLIENT_ID
    );

    /**
     * Клиенты с фиксированным списком продуктов, которые не приостанавливаются
     */
    private Map<Long, Set<BlockType>> vips = Map.of(
            486246L, EnumSet.of(
                    BlockType.CONTEXT_ON_SITE_DIRECT,
                    BlockType.SEARCH_ON_SITE_DIRECT,
                    BlockType.SEARCH_ON_SITE_PREMIUM,
                    BlockType.CONTEXT_ON_SITE_ADBLOCK
            ),
            2984581L, EnumSet.of(
                    BlockType.SEARCH_ON_SITE_DIRECT,
                    BlockType.SEARCH_ON_SITE_MCB,
                    BlockType.SEARCH_ON_SITE_PREMIUM,
                    BlockType.SEARCH_ON_SITE_MARKET,
                    BlockType.CONTEXT_ON_SITE_ADBLOCK
            ),
            8933103L, EnumSet.of(BlockType.MOBILE_APP_RTB),
            9143013L, EnumSet.of(
                    BlockType.MOBILE_APP_RTB,
                    BlockType.VIDEO_AN_SITE_INPAGE,
                    BlockType.VIDEO_AN_SITE_INSTREAM
            )
    );

    /**
     * Продукты клиентов tutby, которые не приостанавливаются
     */
    private Set<BlockType> tutbyProducts = Collections.unmodifiableSet(EnumSet.of(
            BlockType.CONTEXT_ON_SITE_CONTENT,
            BlockType.CONTEXT_ON_SITE_DIRECT,
            BlockType.CONTEXT_ON_SITE_RTB,
            BlockType.MOBILE_APP_RTB,
            BlockType.SEARCH_ON_SITE_DIRECT,
            BlockType.SEARCH_ON_SITE_PREMIUM,
            BlockType.VIDEO_AN_SITE_INPAGE,
            BlockType.VIDEO_AN_SITE_INSTREAM
    ));

    public Set<Long> getSpecialClients() {
        return specialClients;
    }

    public void setSpecialClients(Set<Long> specialClients) {
        this.specialClients = specialClients;
    }

    public Map<Long, Set<BlockType>> getVips() {
        return vips;
    }

    public void setVips(Map<Long, Set<BlockType>> vips) {
        this.vips = vips;
    }

    public Set<BlockType> getTutbyProducts() {
        return tutbyProducts;
    }

    public void setTutbyProducts(Set<BlockType> tutbyProducts) {
        this.tutbyProducts = tutbyProducts;
    }
}
