package ru.yandex.partner.core.entity.agreement.service;

import org.springframework.stereotype.Component;

import ru.yandex.partner.core.block.BlockType;

/**
 * <p>
 * <a href="https://wiki.yandex-team.ru/partner/w/dev/partner2-agreement-by-products/">
 * Разрешённые для запуска/продолжения типы продуктов для заданных типов договоров</a>
 * </p>
 */
@Component
class ProductRunClearance {
    private final ParsedProductRunClearance parsedProductRunClearance;

    ProductRunClearance(ParsedProductRunClearance parsedProductRunClearance) {
        this.parsedProductRunClearance = parsedProductRunClearance;
    }

    public boolean canRunWithSignType(BlockType productType, Integer contractType, SignType signType) {
        if (!parsedProductRunClearance.getKnownContractTypes().contains(contractType)) {
            throw new IllegalArgumentException("Unknown contract type: " + contractType);
        }
        return parsedProductRunClearance.getAllowedKeys().get(
                new ParsedProductRunClearance.Key(productType, contractType)
        ) == signType;
    }
}
