package ru.yandex.partner.core.entity.agreement.service;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

enum SignType {
    SIGNED_OR_FAXED("x");

    private static final Map<String, SignType> LETTER_MAPPING = Stream.of(values())
            .collect(Collectors.toUnmodifiableMap(SignType::getAsLetter, Function.identity()));

    private final String asLetter;

    SignType(String asLetter) {
        this.asLetter = asLetter;
    }

    public static SignType from(String letter) {
        SignType value = LETTER_MAPPING.get(letter);
        if (value == null) {
            throw new IllegalArgumentException(
                    "No " + SignType.class.getCanonicalName() + " constant mapping for key: " + letter
            );
        }
        return value;
    }

    public String getAsLetter() {
        return asLetter;
    }
}
