package ru.yandex.partner.core.entity.assistant.filter;

import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.filter.dbmeta.BooleanFilter;
import ru.yandex.partner.core.filter.dbmeta.NumberFilter;
import ru.yandex.partner.core.filter.meta.MatchMetaFilter;

import static ru.yandex.partner.dbschema.partner.tables.Assistants.ASSISTANTS;

public class AssistantFilters {
    public static final NumberFilter<Assistant, Long> USER_ID = new NumberFilter<>("user_id",
            Assistant.class, ASSISTANTS.USER_ID);

    public static final NumberFilter<Assistant, Long> PAGE_ID = new NumberFilter<>("page_id",
            Assistant.class, ASSISTANTS.PAGE_ID);

    public static final MatchMetaFilter<Assistant, BaseUser> USER = new MatchMetaFilter<>("user",
            Assistant.class);

    public static final BooleanFilter<Assistant> DISSABLED = new BooleanFilter<>("dissabled",
            Assistant.class, ASSISTANTS.DISSABLED);

    public static final BooleanFilter<Assistant> CAN_EDIT = new BooleanFilter<>("can_edit", Assistant.class,
            ASSISTANTS.CAN_EDIT);

    private AssistantFilters() {
    }
}
