package ru.yandex.partner.core.entity.assistant.filter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.assistant.model.Assistant;
import ru.yandex.partner.core.entity.user.filter.UserModelFilterContainer;
import ru.yandex.partner.core.entity.user.model.BaseUser;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.tables.Assistants;
import ru.yandex.partner.dbschema.partner.tables.Users;

@Component
public class AssistantUserMatchDbFilter extends MatchDbFilter<Assistant, BaseUser, BaseUser> {

    private UserModelFilterContainer userModelFilterContainer;

    @Autowired
    public AssistantUserMatchDbFilter() {
        super(AssistantFilters.USER, Assistant.class, BaseUser.class, Assistants.ASSISTANTS.USER_ID, Users.USERS.ID);
    }

    @Autowired
    @Lazy
    public void setUserModelFilterContainer(UserModelFilterContainer userModelFilterContainer) {
        this.userModelFilterContainer = userModelFilterContainer;
    }

    @Override
    protected ModelFilterContainer<BaseUser> getModelFilterContainer() {
        return userModelFilterContainer;
    }
}
