package ru.yandex.partner.core.entity.assistant.repository;

import java.util.Collections;
import java.util.List;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static ru.yandex.partner.dbschema.partner.Tables.ASSISTANTS;

@Component
public class AssistantRepository {

    private final DSLContext dslContext;

    @Autowired
    public AssistantRepository(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    public List<Long> getPageIdsForUserId(Long userId) {
        if (userId == null) {
            return Collections.emptyList();
        }
        return dslContext.selectDistinct(ASSISTANTS.PAGE_ID)
                .from(ASSISTANTS)
                .where(ASSISTANTS.USER_ID.eq(userId))
                .fetch(ASSISTANTS.PAGE_ID, Long.class);
    }
}
