package ru.yandex.partner.core.entity.assistant.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.entity.assistant.repository.AssistantRepository;

import static java.util.Collections.emptyList;

@Service
public class AssistantService {

    private final AssistantRepository assistantRepository;

    @Autowired
    public AssistantService(AssistantRepository assistantRepository) {
        this.assistantRepository = assistantRepository;
    }

    public List<Long> getPageIdsForUserId(Long pageId) {
        if (pageId == null) {
            return emptyList();
        }
        return assistantRepository.getPageIdsForUserId(pageId);
    }

}
