package ru.yandex.partner.core.entity.block

import NPartner.Page.TPartnerPage
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import ru.yandex.direct.multitype.typesupport.TypeSupportAffectionHelper
import ru.yandex.partner.core.bs.BkDataFacade
import ru.yandex.partner.core.bs.BkFiller
import ru.yandex.partner.core.entity.ModelCopyMapper
import ru.yandex.partner.core.entity.block.container.BlockBkDictContainer
import ru.yandex.partner.core.entity.block.model.BaseBlock
import ru.yandex.partner.core.entity.block.repository.type.BlockRepositoryTypeSupportFacade
import ru.yandex.partner.core.entity.common.editablefields.EditableFieldsService
import ru.yandex.partner.core.multitype.service.validation.type.update.EditableFieldValidator

@Configuration
class BlockConfiguration {

    @Bean
    fun blockTypeSupportAffectionHelper(): TypeSupportAffectionHelper<BaseBlock> {
        return TypeSupportAffectionHelper<BaseBlock>(emptySet())
    }

    @Bean
    fun blockEditableFieldsService(
        facade: BlockRepositoryTypeSupportFacade,
        helper: TypeSupportAffectionHelper<BaseBlock>): EditableFieldsService<BaseBlock> {
        return EditableFieldsService<BaseBlock>(facade, helper);
    }

    @Bean
    fun blockEditableFieldValidator(
        editableFieldsService: EditableFieldsService<BaseBlock>,
        mappers: List<ModelCopyMapper<out BaseBlock>>): EditableFieldValidator<BaseBlock> {
        return EditableFieldValidator(editableFieldsService = editableFieldsService,
            copyMappers = mappers
                .map { Pair(it.modelClass, it) }
                .toMap())
    }

    @Bean
    fun bkDataFacade(fillers: List<BkFiller<out BaseBlock, TPartnerPage.TBlock.Builder, BlockBkDictContainer>>) =
        BkDataFacade<BaseBlock, TPartnerPage.TBlock, TPartnerPage.TBlock.Builder, BlockBkDictContainer>(
            { TPartnerPage.TBlock.newBuilder() },
            fillers.sortedBy { it.order() }
        )
}
