package ru.yandex.partner.core.entity.block.actions;

import java.util.Collection;

import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;


public abstract class BlockAction<B extends BlockWithMultistate>
        extends BlockActionWithResult<B, Void> {

    @SuppressWarnings("ParameterNumber")
    public BlockAction(
            ActionConfiguration<B, ?> parentFactory,
            String name,
            Collection<Long> containerIds,
            MultistateGraph<B, BlockStateFlag> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<B> actionErrorHandler,
            Class<B> blockClass
    ) {
        this(
                parentFactory,
                name,
                containerIds,
                multistateGraph,
                actionPerformer,
                actionErrorHandler,
                blockClass,
                true
        );
    }

    @SuppressWarnings("checkstyle:parameternumber")
    public BlockAction(
            ActionConfiguration<B, ?> parentFactory,
            String name,
            Collection<Long> containerIds,
            MultistateGraph<B, BlockStateFlag> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<B> actionErrorHandler,
            Class<B> blockClass,
            boolean writeActionLogs
    ) {
        super(parentFactory, name, containerIds, multistateGraph, actionPerformer, actionErrorHandler, blockClass,
                writeActionLogs);
    }
}
