package ru.yandex.partner.core.entity.block.actions;

import java.util.Collection;

import ru.yandex.partner.core.action.AbstractTransitionActionWithModelProperty;
import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionModelContainerWithModelProperty;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.core.multistate.block.BlockMultistate;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;


public abstract class BlockActionWithResult<B extends BlockWithMultistate, R>
        extends AbstractTransitionActionWithModelProperty<B, BlockStateFlag, R> {

    protected final Class<B> blockClass;
    private final boolean writeActionLogs;

    @SuppressWarnings("ParameterNumber")
    public BlockActionWithResult(
            ActionConfiguration<B, ?> parentFactory,
            String name,
            Collection<Long> containerIds,
            MultistateGraph<B, BlockStateFlag> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<B> actionErrorHandler,
            Class<B> blockClass
    ) {
        this(
                parentFactory,
                name,
                containerIds,
                multistateGraph,
                actionPerformer,
                actionErrorHandler,
                blockClass,
                true
        );
    }

    @SuppressWarnings("checkstyle:parameternumber")
    public BlockActionWithResult(
            ActionConfiguration<B, ?> parentFactory,
            String name,
            Collection<Long> containerIds,
            MultistateGraph<B, BlockStateFlag> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<B> actionErrorHandler,
            Class<B> blockClass,
            boolean writeActionLogs
    ) {
        super(parentFactory, name, containerIds, multistateGraph, actionPerformer, actionErrorHandler);
        this.blockClass = blockClass;
        this.writeActionLogs = writeActionLogs;
    }

    @Override
    public Multistate<BlockStateFlag> getMultistate(B model) {
        return model.getMultistate();
    }

    @Override
    public void setMultistate(ActionModelContainerWithModelProperty<B> container,
                              Multistate<BlockStateFlag> multistate) {
        container.changeProperty(B.MULTISTATE, new BlockMultistate(multistate.getEnabledFlags()));
    }

    @Override
    public boolean writeActionLog() {
        return writeActionLogs;
    }

    @Override
    public Class<B> getEntityClass() {
        return blockClass;
    }
}
