package ru.yandex.partner.core.entity.block.actions.all;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionContext;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionModelContainerImpl;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.ActionUtils;
import ru.yandex.partner.core.action.factories.block.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.action.factories.block.ActionStopFactory;
import ru.yandex.partner.core.entity.block.actions.BlockAction;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@ParametersAreNonnullByDefault
public abstract class BlockActionDelete<B extends BlockWithMultistate>
        extends BlockAction<B> {
    private final ActionSetNeedUpdateFactory<B, BlockStateFlag> actionSetNeedUpdateFactory;
    private final ActionStopFactory<B, BlockStateFlag> blockStopFactory;

    @SuppressWarnings("checkstyle:parameternumber")
    public BlockActionDelete(ActionConfiguration<B, ?> parentFactory,
                             String actionName,
                             Collection<Long> containerIds,
                             ActionSetNeedUpdateFactory<B, BlockStateFlag> actionSetNeedUpdateFactory,
                             ActionStopFactory<B, BlockStateFlag> blockStopFactory,
                             MultistateGraph<B, BlockStateFlag> multistateGraph,
                             ActionPerformer actionPerformer,
                             ActionErrorHandler<B> actionErrorHandler,
                             Class<B> blockClass) {
        super(parentFactory, actionName, containerIds, multistateGraph,
                actionPerformer, actionErrorHandler, blockClass);
        this.actionSetNeedUpdateFactory = actionSetNeedUpdateFactory;
        this.blockStopFactory = blockStopFactory;
    }


    @Override
    public void onAction(ActionContext<B, ActionModelContainerImpl<B>> context,
                         List<ActionModelContainerImpl<B>> containers) {
        var idsWorkingBlocks = ActionUtils
                .filteredItemIdsByMultistateFlag(containers, BlockStateFlag.WORKING);

        var pageIds = StreamEx.of(containers)
                .map(ActionModelContainerImpl::getItem)
                .map(BaseBlock::getPageId)
                .collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        var setNeedUpdate = actionSetNeedUpdateFactory.createAction(getContainerIds());
        var stop = blockStopFactory.createAction(idsWorkingBlocks);
        doNestedActions(stop, setNeedUpdate);
        reducePagesCount(pageIds);
    }

    protected abstract void reducePagesCount(Map<Long, Long> pageIds);

    @Override
    public String getSerializedOpts(Long id) {
        return "{}";
    }

}
