package ru.yandex.partner.core.entity.block.actions.all;

import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.stream.Collectors;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionContext;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionModelContainerImpl;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.entity.IncomingFields;
import ru.yandex.partner.core.entity.block.actions.BlockActionWithResult;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.entity.block.service.BlockAddService;
import ru.yandex.partner.core.entity.block.service.OperationMode;
import ru.yandex.partner.core.entity.page.model.PageWithOwner;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

public class BlockActionDuplicate<B extends BlockWithMultistate, P extends PageWithOwner>
        extends BlockActionWithResult<B, MassResult<B>> {
    private final Class<P> pageClass;
    private final BlockAddService<BlockWithMultistate> blockAddService;

    @SuppressWarnings("checkstyle:parameternumber")
    public BlockActionDuplicate(ActionConfiguration<B, ?> parentFactory,
                                String name,
                                Collection<Long> containerIds,
                                MultistateGraph<B, BlockStateFlag> multistateGraph,
                                ActionPerformer actionPerformer,
                                ActionErrorHandler<B> actionErrorHandler,
                                Class<B> blockClass,
                                Class<P> pageClass,
                                BlockAddService<BlockWithMultistate> blockAddService) {
        super(parentFactory, name, containerIds, multistateGraph, actionPerformer, actionErrorHandler, blockClass);
        this.pageClass = pageClass;
        this.blockAddService = blockAddService;
    }

    @Override
    public MassResult<B> onActionWithResult(ActionContext<B, ActionModelContainerImpl<B>> blockActionContext,
                                            List<ActionModelContainerImpl<B>> containers) {
        List<B> models = containers.stream()
                .map(ActionModelContainerImpl::getItem)
                .collect(Collectors.toList());
        Multimap<Model, ModelProperty<?, ?>> multimap = Multimaps.newSetMultimap(
                new IdentityHashMap<>(), HashSet::new
        );
        models.forEach(model ->
                multimap.putAll(model, new HashSet<>(getDependsOn()))
        );
        var actionsResult = blockAddService.addModels(
                blockClass,
                models,
                pageClass,
                new IncomingFields(multimap),
                OperationMode.DUPLICATE,
                blockContainer -> {
                }
        );

        var convertedMassResult = actionsResult.getResult(getEntityClass()).iterator().next();
        getActionErrorHandler()
                .addValidationErrors((ValidationResult<List<B>, Defect>)
                        convertedMassResult.getValidationResult());

        return convertedMassResult;
    }

    @Override
    public String getSerializedOpts(Long id) {
        return "{}";
    }
}
