package ru.yandex.partner.core.entity.block.actions.all;

import java.util.Collection;
import java.util.List;

import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionContext;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionModelContainerImpl;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.block.ActionStartFactory;
import ru.yandex.partner.core.entity.block.actions.BlockAction;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

public class BlockActionRestoreWithPage<B extends BlockWithMultistate> extends BlockAction<B> {
    private final ActionStartFactory<B, BlockStateFlag> actionStartFactory;

    @SuppressWarnings("ParameterNumber")
    public BlockActionRestoreWithPage(
            ActionConfiguration<B, ?> parentFactory,
            Collection<Long> containerIds,
            MultistateGraph<B, BlockStateFlag> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<B> actionErrorHandler,
            Class<B> blockClass,
            ActionStartFactory<B, BlockStateFlag> actionStartFactory) {
        super(
                parentFactory,
                BlockActionsEnum.RESTORE_WITH_PAGE.getActionName(),
                containerIds,
                multistateGraph,
                actionPerformer,
                actionErrorHandler,
                blockClass
        );
        this.actionStartFactory = actionStartFactory;
    }

    @Override
    public void onAction(ActionContext<B, ActionModelContainerImpl<B>> actionContext,
                         List<ActionModelContainerImpl<B>> containers) {

        List<Long> startableIds = filteredItemIdsByActionAllowed(BlockActionsEnum.START, containers);

        doNestedActions(actionStartFactory.createAction(startableIds));
    }

    @Override
    public String getSerializedOpts(Long id) {
        return "{}";
    }
}
