package ru.yandex.partner.core.entity.block.actions.all;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionContext;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionModelContainerImpl;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.MultistateChangingActionFactory;
import ru.yandex.partner.core.entity.block.actions.BlockAction;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@ParametersAreNonnullByDefault
public class BlockActionSetNeedUpdate<B extends BlockWithMultistate, P extends BasePage>
        extends BlockAction<B> {
    private final MultistateChangingActionFactory<P, ?> setNeedUpdateFactory;

    @SuppressWarnings("checkstyle:parameternumber")
    public BlockActionSetNeedUpdate(ActionConfiguration<B, ?> parentFactory,
                                    String actionName,
                                    Collection<Long> containerIds,
                                    MultistateChangingActionFactory<P, ?> setNeedUpdateFactory,
                                    MultistateGraph<B, BlockStateFlag> multistateGraph,
                                    ActionPerformer actionPerformer,
                                    ActionErrorHandler<B> actionErrorHandler,
                                    Class<B> blockClass) {
        super(parentFactory, actionName, containerIds, multistateGraph,
                actionPerformer, actionErrorHandler, blockClass);
        this.setNeedUpdateFactory = setNeedUpdateFactory;
    }


    @Override
    public void onAction(ActionContext<B, ActionModelContainerImpl<B>> context,
                         List<ActionModelContainerImpl<B>> containers) {
        var pageIds = StreamEx.of(containers).map(ActionModelContainerImpl::getItem)
                .map(BaseBlock::getPageId).toSet();
        var pageSetNeedUpdate = setNeedUpdateFactory.createAction(pageIds);
        doNestedActions(pageSetNeedUpdate);
    }

    @Override
    public String getSerializedOpts(Long id) {
        return "{}";
    }

    @Override
    public boolean writeActionLog() {
        return false;
    }
}
