package ru.yandex.partner.core.entity.block.actions.all;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionContext;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionModelContainerImpl;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.entity.block.actions.BlockAction;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@ParametersAreNonnullByDefault
public class BlockActionStart<B extends BlockWithMultistate> extends BlockAction<B> {

    @SuppressWarnings("ParameterNumber")
    public BlockActionStart(ActionConfiguration<B, ?> parentFactory, Collection<Long> containerIds,
                            String actionName,
                            MultistateGraph<B, BlockStateFlag> multistateGraph,
                            ActionPerformer actionPerformer, ActionErrorHandler<B> actionErrorHandler,
                            Class<B> blockClass) {
        super(parentFactory, actionName, containerIds, multistateGraph, actionPerformer,
                actionErrorHandler, blockClass);
    }

    @Override
    public void onAction(ActionContext<B, ActionModelContainerImpl<B>> context,
                         List<ActionModelContainerImpl<B>> containers) {
        //no logic, multistate changes only
    }

    @Override
    public String getSerializedOpts(Long id) {
        return "{}";
    }

}
