package ru.yandex.partner.core.entity.block.actions.all.factories;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.block.ActionStartFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionRestoreWithPage;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

public class BlockActionRestoreWithPageFactory<B extends BlockWithMultistate>
        extends CustomPayloadActionFactory<B, BlockActionRestoreWithPage<B>> {
    private final Class<B> blockClass;
    private final MultistateGraph<B, BlockStateFlag> multistateGraph;
    private final ActionPerformer actionPerformer;
    private final ActionErrorHandler<B> actionErrorHandler;
    private final ActionStartFactory<B, BlockStateFlag> blockStartActionFactory;

    public BlockActionRestoreWithPageFactory(
            Class<B> blockClass,
            MultistateGraph<B, BlockStateFlag> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<B> actionErrorHandler,
            ActionStartFactory<B, BlockStateFlag> blockStartActionFactory) {
        super(BlockActionsEnum.RESTORE_WITH_PAGE, multistateGraph);
        this.blockClass = blockClass;
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.actionErrorHandler = actionErrorHandler;
        this.blockStartActionFactory = blockStartActionFactory;
    }

    public BlockActionRestoreWithPage<B> restoreWithPage(Collection<Long> ids) {
        return new BlockActionRestoreWithPage<>(
                getActionConfiguration(),
                ids,
                multistateGraph,
                actionPerformer,
                actionErrorHandler,
                blockClass,
                blockStartActionFactory
        );
    }

    @Override
    public String getName() {
        return BlockActionsEnum.RESTORE_WITH_PAGE.getActionName();
    }

    @Override
    public BlockActionRestoreWithPage<B> createAction(List<Long> ids, JsonNode payload) {
        return restoreWithPage(ids);
    }

    @Override
    public Class<B> getModelClass() {
        return blockClass;
    }
}
