package ru.yandex.partner.core.entity.block.actions.all.factories;

import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.ActionConfigurationFactory;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.FieldSetType;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionDuplicate;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.entity.block.service.BlockAddService;
import ru.yandex.partner.core.entity.page.model.PageWithOwner;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;


public abstract class BlockDuplicateFactory<B extends BlockWithMultistate>
        extends CustomPayloadActionFactory<B, BlockActionDuplicate<B, ?>> {

    private final MultistateGraph<B, BlockStateFlag> multistateGraph;
    private final ActionPerformer actionPerformer;
    private final ActionErrorHandler<B> actionErrorHandler;
    private final Class<B> blockClass;
    private final Class<? extends PageWithOwner> pageClass;
    private final BlockAddService<BlockWithMultistate> blockAddService;

    @SuppressWarnings("ParameterNumber")
    public BlockDuplicateFactory(
            ActionConfigurationFactory<B, BlockActionDuplicate<B, ?>> actionConfigurationFactory,
            MultistateGraph<B, BlockStateFlag> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<B> actionErrorHandler,
            Class<B> blockClass,
            Class<? extends PageWithOwner> pageClass,
            BlockAddService<BlockWithMultistate> blockAddService
    ) {
        super(actionConfigurationFactory);
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.actionErrorHandler = actionErrorHandler;
        this.blockClass = blockClass;
        this.pageClass = pageClass;
        this.blockAddService = blockAddService;
    }

    @Override
    public BlockActionDuplicate<B, ?> createAction(List<Long> ids, JsonNode payload) {
        return new BlockActionDuplicate<>(
                getActionConfiguration(),
                getName(),
                ids,
                multistateGraph,
                actionPerformer,
                actionErrorHandler,
                blockClass,
                pageClass,
                blockAddService
        );
    }

    @Override
    public String getName() {
        return "duplicate";
    }

    @Override
    public FieldSetType getReturnFields() {
        return FieldSetType.NONE;
    }

    @Override
    public Class<B> getModelClass() {
        return blockClass;
    }
}
