package ru.yandex.partner.core.entity.block.actions.all.factories;

import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.block.actions.BlockAction;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockMultistateAction;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

/**
 * Фабрика для любого простого экшена, который меняет только мульитстатус
 */
public class BlockMultistateActionFactory<B extends BlockWithMultistate>
        extends CustomPayloadActionFactory<B, BlockAction<B>> {
    private final Class<B> blockClass;
    private final BlockActionsEnum action;
    private final MultistateGraph<B, BlockStateFlag> blockMultistate;
    private final ActionPerformer actionPerformer;
    private final ActionErrorHandler<B> actionErrorHandler;
    private final boolean writeActionLog;

    public BlockMultistateActionFactory(
            Class<B> blockClass,
            BlockActionsEnum action,
            MultistateGraph<B, BlockStateFlag> blockMultistate,
            ActionPerformer actionPerformer,
            ActionErrorHandler<B> actionErrorHandler,
            boolean writeActionLog) {
        super(new SmartActionConfigurationFactory<>(action, blockMultistate));
        this.blockClass = blockClass;
        this.action = action;
        this.blockMultistate = blockMultistate;
        this.actionPerformer = actionPerformer;
        this.actionErrorHandler = actionErrorHandler;
        this.writeActionLog = writeActionLog;
    }

    @Override
    public String getName() {
        return action.getActionName();
    }

    public BlockAction<B> createAction(List<Long> ids) {
        return new BlockMultistateAction<>(
                getActionConfiguration(),
                getName(),
                ids,
                blockMultistate,
                actionPerformer,
                actionErrorHandler,
                blockClass,
                writeActionLog
        );
    }

    @Override
    public BlockAction<B> createAction(List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public Class<B> getModelClass() {
        return blockClass;
    }
}
