package ru.yandex.partner.core.entity.block.actions.defects.presentation;

import org.jetbrains.annotations.NotNull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;


public enum BlockActionDefectMsg implements GettextMsg {

    CAN_NOT_START_WITH_YOUR_AGREEMENT(msg("You can't start this product with your agreement"),
            "lib__Application__Model__Product__AN__ContextOnSite__Direct.pm"),
    INVALID_AGREEMENT(msg("You can't start this product because partner has invalid agreement"),
            "lib__Application__Model__Product.pm"),
    ARCHIVED_BLOCK(msg("You cannot edit this block because the block archived"),
            "lib__Application__Model__Block.pm");


    private final GettextMsgPayload payload;
    private final String keyset;

    BlockActionDefectMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    BlockActionDefectMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @NotNull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @NotNull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
