package ru.yandex.partner.core.entity.block.actions.defects.presentation;

import org.jetbrains.annotations.NotNull;

import ru.yandex.partner.libs.i18n.GettextMsg;
import ru.yandex.partner.libs.i18n.GettextMsgPayload;

import static ru.yandex.partner.libs.i18n.GettextMsgPayload.Builder.msg;


public enum BlockFieldsDefectMsg implements GettextMsg {
    INVALID_BLOCK_TYPE(
            msg("Invalid block_type value"),
            "lib__Application__Model__Product__InternalAN__MobileApp__RTB.pm"
    ),
    INVALID_DIRECT_BLOCK(
            msg("Invalid direct block type"),
            "lib__Application__Model__Product__AN__MobileApp__RTB.pm"
    ),
    FORBIDDEN_TO_CHANGE(
            msg("Field forbidden to change"),
            "lib__Application__Model__Product__AN__MobileApp__RTB.pm"
    );

    private final GettextMsgPayload payload;
    private final String keyset;

    BlockFieldsDefectMsg(GettextMsgPayload.Builder builder, String keyset) {
        this(builder.build(), keyset);
    }

    BlockFieldsDefectMsg(GettextMsgPayload payload, String keyset) {
        this.payload = payload;
        this.keyset = keyset;
    }

    @NotNull
    @Override
    public GettextMsgPayload getPayload() {
        return payload;
    }

    @NotNull
    @Override
    public String getKeysetName() {
        return keyset;
    }
}
