package ru.yandex.partner.core.entity.block.actions.rtb.external;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.configuration.annotation.TransactionWithFallbackScope;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionType;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.factories.BlockActionRestoreWithPageFactory;
import ru.yandex.partner.core.entity.block.actions.all.factories.BlockMultistateActionFactory;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@Configuration
public class RtbActionsConfiguration {
    private final MultistateGraph<RtbBlock, BlockStateFlag> rtbMultistate;
    private final ActionPerformer actionPerformer;
    private final ActionErrorHandler<RtbBlock> actionErrorHandler;

    public RtbActionsConfiguration(
            MultistateGraph<RtbBlock, BlockStateFlag> rtbMultistate,
            ActionPerformer actionPerformer,
            ActionErrorHandler<RtbBlock> actionErrorHandler
    ) {
        this.rtbMultistate = rtbMultistate;
        this.actionPerformer = actionPerformer;
        this.actionErrorHandler = actionErrorHandler;
    }

    @BlockActionType(BlockActionsEnum.DELETE_WITH_PAGE)
    @Bean
    BlockMultistateActionFactory<RtbBlock> deleteWithPageActionFactory() {
        return simpleActionFactory(BlockActionsEnum.DELETE_WITH_PAGE);
    }

    @BlockActionType(BlockActionsEnum.RESTORE_WITH_PAGE)
    @Bean
    BlockActionRestoreWithPageFactory<RtbBlock> restoreWithPageActionFactory(
            RtbBlockStartFactory rtbBlockStartFactory
    ) {
        return new BlockActionRestoreWithPageFactory<>(
                RtbBlock.class,
                rtbMultistate,
                actionPerformer,
                actionErrorHandler,
                rtbBlockStartFactory
        );
    }

    @BlockActionType(BlockActionsEnum.RESET_CHECK_STATISTICS)
    @Bean
    BlockMultistateActionFactory<RtbBlock> resetCheckStatisticsActionFactory() {
        return simpleActionFactory(BlockActionsEnum.RESET_CHECK_STATISTICS);
    }

    @BlockActionType(BlockActionsEnum.START_UPDATE)
    @Bean
    BlockMultistateActionFactory<RtbBlock> startUpdateActionFactory() {
        return simpleActionFactory(BlockActionsEnum.START_UPDATE, false);
    }

    @BlockActionType(BlockActionsEnum.STOP_UPDATE)
    @Bean
    BlockMultistateActionFactory<RtbBlock> stopUpdateActionFactory() {
        return simpleActionFactory(BlockActionsEnum.STOP_UPDATE, false);
    }

    @TransactionWithFallbackScope
    @Bean
    BlockActionErrorHandler<RtbBlock> rtbBlockActionErrorHandler() {
        return new BlockActionErrorHandler<RtbBlock>();
    }

    private BlockMultistateActionFactory<RtbBlock> simpleActionFactory(BlockActionsEnum action) {
        return simpleActionFactory(action, true);
    }

    private BlockMultistateActionFactory<RtbBlock> simpleActionFactory(
            BlockActionsEnum action, boolean writeActionLog) {
        return new BlockMultistateActionFactory<>(
                RtbBlock.class,
                action,
                rtbMultistate,
                actionPerformer,
                actionErrorHandler,
                writeActionLog
        );
    }
}
