package ru.yandex.partner.core.entity.block.actions.rtb.external;

import java.util.function.Function;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.entity.block.RtbCopyMapper;
import ru.yandex.partner.core.entity.block.actions.BlockActionContext;
import ru.yandex.partner.core.entity.block.actions.log.RtbBlockActionsLogger;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.service.BlockService;
import ru.yandex.partner.core.entity.block.service.BlockUpdateOperationFactory;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class RtbBlockActionContext extends BlockActionContext<RtbBlock> {

    @Autowired
    public RtbBlockActionContext(RtbBlockActionsLogger actionsLogger, ActionErrorHandler<RtbBlock> errorHandler,
                                 BlockService blockService, RtbCopyMapper rtbCopyMapper,
                                 BlockUpdateOperationFactory blockUpdateOperationFactory) {
        super(actionsLogger, errorHandler, blockService, rtbCopyMapper, blockUpdateOperationFactory);
    }

    @Override
    public Class<RtbBlock> getEntityClass() {
        return RtbBlock.class;
    }

    @Override
    protected Function<Long, BaseBlock> getModelStubCreator() {
        return id -> new RtbBlock().withId(id);
    }
}
