package ru.yandex.partner.core.entity.block.actions.rtb.external;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionContextFacade;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.block.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.action.factories.block.ActionStopFactory;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionDelete;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@ParametersAreNonnullByDefault
public class RtbBlockActionDelete extends BlockActionDelete<RtbBlock> {
    private final ActionContextFacade actionContextFacade;

    @SuppressWarnings("checkstyle:parameternumber")
    public RtbBlockActionDelete(ActionConfiguration<RtbBlock, ?> parentFactory,
                                String actionName,
                                Collection<Long> containerIds,
                                ActionSetNeedUpdateFactory<RtbBlock, BlockStateFlag> actionSetNeedUpdateFactory,
                                ActionStopFactory<RtbBlock, BlockStateFlag> blockStopFactory,
                                MultistateGraph<RtbBlock, BlockStateFlag> multistateGraph,
                                ActionPerformer actionPerformer,
                                ActionErrorHandler<RtbBlock> actionErrorHandler) {
        super(parentFactory, actionName, containerIds, actionSetNeedUpdateFactory, blockStopFactory, multistateGraph,
                actionPerformer, actionErrorHandler, RtbBlock.class);
        this.actionContextFacade = actionPerformer.getActionContextFacade();
    }

    @Override
    protected void reducePagesCount(Map<Long, Long> pageIds) {
        var pageContainers = actionContextFacade
                .getActionContext(ContextPage.class)
                .getContainers(StreamEx.of(pageIds.keySet()).toList(), Set.of(ContextPage.BLOCKS_COUNT), true);
        pageContainers.forEach(it ->
                it.changeProperty(ContextPage.BLOCKS_COUNT,
                        it.getItem().getBlocksCount() - pageIds.get(it.getItem().getId()))
        );
    }
}
