package ru.yandex.partner.core.entity.block.actions.rtb.external;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionContextFacade;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.factories.block.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.action.factories.block.ActionStartFactory;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.agreement.service.AgreementChecker;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionRestore;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;
import ru.yandex.partner.libs.rbac.userrole.UserRoleService;

@ParametersAreNonnullByDefault
public class RtbBlockActionRestore extends BlockActionRestore<RtbBlock, ContextPage> {
    private final ActionContextFacade actionContextFacade;

    @SuppressWarnings("checkstyle:parameternumber")
    public RtbBlockActionRestore(ActionConfiguration<RtbBlock, ?> parentFactory, Collection<Long> containerIds,
                                 String actionName,
                                 ActionSetNeedUpdateFactory<RtbBlock, BlockStateFlag> actionSetNeedUpdateFactory,
                                 ActionStartFactory<RtbBlock, BlockStateFlag> actionStartFactory,
                                 MultistateGraph<RtbBlock, BlockStateFlag> multistateGraph,
                                 ActionPerformer actionPerformer, ActionErrorHandler<RtbBlock> actionErrorHandler,
                                 AgreementChecker agreementChecker,
                                 UserRoleService userRoleService,
                                 ActionUserIdContext actionUserIdContext) {
        super(parentFactory, containerIds, actionName, actionSetNeedUpdateFactory, actionStartFactory, multistateGraph,
                actionPerformer, actionErrorHandler, RtbBlock.class, agreementChecker,
                userRoleService, actionUserIdContext);
        this.actionContextFacade = actionPerformer.getActionContextFacade();

    }

    @Override
    protected void incrementPagesCount(Map<Long, Long> pageIds) {
        var pageContainers = actionContextFacade.getActionContext(ContextPage.class)
                .getContainers(StreamEx.of(pageIds.keySet()).toList(), Set.of(ContextPage.BLOCKS_COUNT), true);
        pageContainers.forEach(it ->
                        it.changeProperty(ContextPage.BLOCKS_COUNT,
                                it.getItem().getBlocksCount() + pageIds.get(it.getItem().getId()))
                //TODO: PI-24891 валидация пейджей происходит в валидаторе, однако для балковых операций это может быть
                // проблемой, так как блоки могут записаться в базу а пейджи нет
        );
    }

    @Override
    protected Map<Long, ContextPage> getPages(Set<RtbBlock> blocks) {
        return StreamEx.of(blocks).toMap(RtbBlock::getPageId, RtbBlock::getCampaign);
    }

    @Override
    protected List<BlockType> getBlockTypesForChecker() {
        return List.of(BlockType.CONTEXT_ON_SITE_RTB);
    }
}
