package ru.yandex.partner.core.entity.block.actions.rtb.external;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.action.ActionContextFacade;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionAdd;
import ru.yandex.partner.core.entity.block.actions.all.factories.BlockAddActionFactory;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.multistate.RtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.entity.page.model.PageWithBlocksLimit;
import ru.yandex.partner.core.service.entitymanager.EntityManager;

@Component
public class RtbBlockAddFactory
        extends CustomPayloadActionFactory<RtbBlock, BlockActionAdd<RtbBlock>>
        implements BlockAddActionFactory<RtbBlock> {

    private final RtbBlockMultistateGraph multistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<RtbBlock> actionErrorHandler;
    private final ObjectMapper objectMapper;
    private final RtbBlockSetNeedUpdateFactory actionSetNeedUpdateFactory;
    private final RtbBlockStartFactory blockStartFactory;
    private final EntityManager entityManager;

    @SuppressWarnings("ParameterNumber")
    @Autowired
    public RtbBlockAddFactory(
            RtbBlockMultistateGraph multistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<RtbBlock> actionErrorHandler,
            ObjectMapper objectMapper,
            RtbBlockSetNeedUpdateFactory actionSetNeedUpdateFactory,
            RtbBlockStartFactory blockStartFactory, EntityManager entityManager) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.ADD, multistateGraph));
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.actionErrorHandler = actionErrorHandler;
        this.objectMapper = objectMapper;
        this.actionSetNeedUpdateFactory = actionSetNeedUpdateFactory;
        this.blockStartFactory = blockStartFactory;
        this.entityManager = entityManager;
    }

    @Override
    public String getName() {
        return BlockActionsEnum.ADD.getActionName();
    }

    @Override
    public BlockActionAdd<RtbBlock> createAction(
            Map<Long, RtbBlock> addedModels,
            Map<Long, Set<ModelProperty<? super RtbBlock, ?>>> addedProps
    ) {
        return new BlockActionAdd<>(
                getActionConfiguration(),
                getName(),
                addedModels,
                addedProps,
                multistateGraph,
                actionPerformer,
                actionErrorHandler,
                objectMapper,
                RtbBlock.class,
                actionSetNeedUpdateFactory,
                blockStartFactory,
                entityManager, this::incBlocksCount);
    }

    @Override
    public BlockActionAdd<RtbBlock> createAction(List<Long> ids, JsonNode payload) {
        throw new UnsupportedOperationException("RtbBlockAddFactory#createAction");
    }

    @Override
    public Class<RtbBlock> getModelClass() {
        return RtbBlock.class;
    }

    private void incBlocksCount(Map<Long, Long> pageIds, ActionContextFacade actionContextFacade) {
        var pageContainers = actionContextFacade.getActionContext(ContextPage.class)
                .getContainers(
                        pageIds.keySet(),
                        Set.of(PageWithBlocksLimit.BLOCKS_COUNT, BasePage.ID),
                        true
                );
        pageContainers.forEach(it ->
                it.changeProperty(PageWithBlocksLimit.BLOCKS_COUNT,
                        it.getItem().getBlocksCount() + pageIds.get(it.getItem().getId()))
        );
    }
}
