package ru.yandex.partner.core.entity.block.actions.rtb.external;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionDelete;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.multistate.RtbBlockMultistateGraph;

@Component
public class RtbBlockDeleteFactory extends CustomPayloadActionFactory<RtbBlock, BlockActionDelete<RtbBlock>> {
    private final RtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<RtbBlock> errorHandler;
    private final RtbBlockSetNeedUpdateFactory rtbBlockSetNeedUpdateFactory;
    private final RtbBlockStopFactory rtbBlockStopFactory;

    @Autowired
    public RtbBlockDeleteFactory(
            RtbBlockMultistateGraph rtbBlockMultistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<RtbBlock> errorHandler,
            RtbBlockSetNeedUpdateFactory rtbBlockSetNeedUpdateFactory,
            RtbBlockStopFactory rtbBlockStopFactory) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.DELETE, rtbBlockMultistateGraph));
        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.rtbBlockSetNeedUpdateFactory = rtbBlockSetNeedUpdateFactory;
        this.rtbBlockStopFactory = rtbBlockStopFactory;
    }

    @Override
    public BlockActionDelete<RtbBlock> createAction(List<Long> ids, JsonNode payload) {
        return delete(ids);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.DELETE.getActionName();
    }

    public BlockActionDelete<RtbBlock> delete(Collection<Long> ids) {
        return new RtbBlockActionDelete(
                getActionConfiguration(),
                getName(),
                ids,
                rtbBlockSetNeedUpdateFactory,
                rtbBlockStopFactory,
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler);
    }

    @Override
    public Class<RtbBlock> getModelClass() {
        return RtbBlock.class;
    }

}
