package ru.yandex.partner.core.entity.block.actions.rtb.external;

import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.factories.BlockDuplicateFactory;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.multistate.RtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.block.service.BlockAddService;
import ru.yandex.partner.core.entity.page.model.ContextPage;

@Component
public class RtbBlockDuplicateFactory extends BlockDuplicateFactory<RtbBlock> {

    @Autowired
    public RtbBlockDuplicateFactory(
            RtbBlockMultistateGraph multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<RtbBlock> actionErrorHandler,
            BlockAddService<BlockWithMultistate> rtbBlockBlockAddService
    ) {
        super(
                new SmartActionConfigurationFactory<>(BlockActionsEnum.DUPLICATE,
                        multistateGraph,
                        RtbBlock.allModelProperties().stream()
                                .map(mp -> (ModelProperty<? super RtbBlock, ?>) mp)
                                .collect(Collectors.toList())
                ),
                multistateGraph,
                actionPerformer,
                actionErrorHandler,
                RtbBlock.class,
                ContextPage.class,
                rtbBlockBlockAddService
        );
    }
}
