package ru.yandex.partner.core.entity.block.actions.rtb.external;

import java.util.Collection;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.ModelPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.IncomingFields;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionEdit;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.multistate.RtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.block.service.type.update.BlockUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.entity.block.service.validation.type.BlockValidationTypeSupportFacade;

@Component
public class RtbBlockEditFactory extends ModelPayloadActionFactory<RtbBlock, BlockActionEdit<RtbBlock>> {
    private final RtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<RtbBlock> errorHandler;
    private final ObjectMapper objectMapper;
    private final RtbBlockSetNeedUpdateFactory setNeedUpdateFactory;
    private final BlockUpdateOperationTypeSupportFacade blockUpdateOperationTypeSupportFacade;
    private final BlockValidationTypeSupportFacade blockValidationTypeSupportFacade;

    @SuppressWarnings("ParameterNumber")
    @Autowired
    public RtbBlockEditFactory(
            RtbBlockMultistateGraph rtbBlockMultistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<RtbBlock> errorHandler,
            RtbBlockSetNeedUpdateFactory setNeedUpdateFactory,
            BlockUpdateOperationTypeSupportFacade blockUpdateOperationTypeSupportFacade,
            ObjectMapper objectMapper, BlockValidationTypeSupportFacade blockValidationTypeSupportFacade) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.EDIT, rtbBlockMultistateGraph));

        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.objectMapper = objectMapper;
        this.setNeedUpdateFactory = setNeedUpdateFactory;
        this.blockUpdateOperationTypeSupportFacade = blockUpdateOperationTypeSupportFacade;
        this.blockValidationTypeSupportFacade = blockValidationTypeSupportFacade;
    }

    public BlockActionEdit<RtbBlock> edit(Collection<? extends ModelChanges<? super RtbBlock>> modelChanges) {
        return edit(modelChanges, new IncomingFields());
    }

    public BlockActionEdit<RtbBlock> edit(
            Collection<? extends ModelChanges<? super RtbBlock>> modelChanges,
            IncomingFields incomingFields
    ) {
        return new BlockActionEdit<>(
                getActionConfiguration(),
                getName(),
                modelChanges.stream().map(it -> it.castModel(RtbBlock.class)).collect(Collectors.toList()),
                incomingFields,
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler,
                objectMapper,
                setNeedUpdateFactory,
                blockUpdateOperationTypeSupportFacade,
                RtbBlock.class,
                blockValidationTypeSupportFacade);
    }

    @Override
    public BlockActionEdit<RtbBlock> createAction(
            Collection<ModelChanges<? super RtbBlock>> modelChanges,
            IncomingFields updatedFields
    ) {
        return edit(modelChanges, updatedFields);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.EDIT.getActionName();
    }

    @Override
    public Class<RtbBlock> getModelClass() {
        return RtbBlock.class;
    }
}
