package ru.yandex.partner.core.entity.block.actions.rtb.external;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.MultistateChangingActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.agreement.service.AgreementChecker;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionRestore;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.multistate.RtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.rbac.userrole.UserRoleService;

@Component
public class RtbBlockRestoreFactory extends CustomPayloadActionFactory<RtbBlock,
        BlockActionRestore<RtbBlock, ContextPage>>
        implements MultistateChangingActionFactory<RtbBlock, BlockStateFlag> {
    private final RtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<RtbBlock> errorHandler;
    private final RtbBlockSetNeedUpdateFactory rtbBlockSetNeedUpdateFactory;
    private final RtbBlockStartFactory rtbBlockStartFactory;
    private final AgreementChecker agreementChecker;
    private final UserRoleService userRoleService;
    private final ActionUserIdContext actionUserIdContext;

    @Autowired
    @SuppressWarnings("checkstyle:parameternumber")
    public RtbBlockRestoreFactory(
            RtbBlockMultistateGraph rtbBlockMultistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<RtbBlock> errorHandler,
            RtbBlockSetNeedUpdateFactory rtbBlockSetNeedUpdateFactory,
            RtbBlockStartFactory rtbBlockStartFactory,
            AgreementChecker agreementChecker,
            UserRoleService userRoleService,
            ActionUserIdContext actionUserIdContext
    ) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.RESTORE, rtbBlockMultistateGraph));
        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.rtbBlockSetNeedUpdateFactory = rtbBlockSetNeedUpdateFactory;
        this.rtbBlockStartFactory = rtbBlockStartFactory;
        this.agreementChecker = agreementChecker;
        this.userRoleService = userRoleService;
        this.actionUserIdContext = actionUserIdContext;
    }

    @Override
    public BlockActionRestore<RtbBlock, ContextPage> createAction(Collection<Long> ids) {
        return new RtbBlockActionRestore(
                getActionConfiguration(),
                ids,
                getName(),
                rtbBlockSetNeedUpdateFactory,
                rtbBlockStartFactory,
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler,
                agreementChecker,
                userRoleService,
                actionUserIdContext);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.RESTORE.getActionName();
    }

    @Override
    public BlockActionRestore<RtbBlock, ContextPage> createAction(List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public Class<RtbBlock> getModelClass() {
        return RtbBlock.class;
    }
}
