package ru.yandex.partner.core.entity.block.actions.rtb.external;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.action.factories.block.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionSetNeedUpdate;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.multistate.RtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.page.actions.factory.ContextPageSetNeedUpdateActionFactory;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;

@Component
public class RtbBlockSetNeedUpdateFactory
        extends CustomPayloadActionFactory<RtbBlock, BlockActionSetNeedUpdate<RtbBlock, ContextPage>>
        implements ActionSetNeedUpdateFactory<RtbBlock, BlockStateFlag> {
    private final RtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<RtbBlock> errorHandler;
    private final ContextPageSetNeedUpdateActionFactory contextPageSetNeedUpdateActionFactory;

    @Autowired
    public RtbBlockSetNeedUpdateFactory(RtbBlockMultistateGraph rtbBlockMultistateGraph,
                                        ActionPerformer actionPerformer,
                                        BlockActionErrorHandler<RtbBlock> errorHandler,
                                        ContextPageSetNeedUpdateActionFactory contextPageSetNeedUpdateActionFactory) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.SET_NEED_UPDATE, rtbBlockMultistateGraph));
        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.contextPageSetNeedUpdateActionFactory = contextPageSetNeedUpdateActionFactory;
    }

    @Override
    public BlockActionSetNeedUpdate<RtbBlock, ContextPage> createAction(List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.SET_NEED_UPDATE.getActionName();
    }

    @Override
    public BlockActionSetNeedUpdate<RtbBlock, ContextPage> createAction(Collection<Long> ids) {
        return new BlockActionSetNeedUpdate<>(
                getActionConfiguration(),
                getName(),
                ids,
                contextPageSetNeedUpdateActionFactory,
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler,
                RtbBlock.class
        );
    }

    @Override
    public Class<RtbBlock> getModelClass() {
        return RtbBlock.class;
    }
}
