package ru.yandex.partner.core.entity.block.actions.rtb.external;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.action.factories.block.ActionStartFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionStart;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.multistate.RtbBlockMultistateGraph;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;

@Component
public class RtbBlockStartFactory extends CustomPayloadActionFactory<RtbBlock, BlockActionStart<RtbBlock>>
        implements ActionStartFactory<RtbBlock, BlockStateFlag> {
    private final RtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<RtbBlock> errorHandler;

    @Autowired
    public RtbBlockStartFactory(RtbBlockMultistateGraph rtbBlockMultistateGraph,
                                ActionPerformer actionPerformer, BlockActionErrorHandler<RtbBlock> errorHandler) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.START, rtbBlockMultistateGraph));
        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
    }

    @Override
    public BlockActionStart<RtbBlock> createAction(Collection<Long> ids) {
        return new BlockActionStart<>(
                getActionConfiguration(),
                ids,
                getName(),
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler,
                RtbBlock.class
        );
    }

    @Override
    public String getName() {
        return BlockActionsEnum.START.getActionName();
    }

    @Override
    public BlockActionStart<RtbBlock> createAction(List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public Class<RtbBlock> getModelClass() {
        return RtbBlock.class;
    }
}
