package ru.yandex.partner.core.entity.block.actions.rtb.external;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.action.factories.block.ActionStopFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionStop;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.multistate.RtbBlockMultistateGraph;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;

@Component
public class RtbBlockStopFactory extends CustomPayloadActionFactory<RtbBlock, BlockActionStop<RtbBlock>>
        implements ActionStopFactory<RtbBlock, BlockStateFlag> {
    private final RtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<RtbBlock> errorHandler;

    @Autowired
    public RtbBlockStopFactory(RtbBlockMultistateGraph rtbBlockMultistateGraph,
                               ActionPerformer actionPerformer,
                               BlockActionErrorHandler<RtbBlock> errorHandler) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.STOP, rtbBlockMultistateGraph));
        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
    }

    @Override
    public BlockActionStop<RtbBlock> createAction(List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.STOP.getActionName();
    }

    @Override
    public BlockActionStop<RtbBlock> createAction(Collection<Long> ids) {
        return new BlockActionStop<>(
                getActionConfiguration(),
                getName(),
                ids,
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler,
                RtbBlock.class
        );
    }

    @Override
    public Class<RtbBlock> getModelClass() {
        return RtbBlock.class;
    }
}
