package ru.yandex.partner.core.entity.block.actions.rtb.external

import com.fasterxml.jackson.databind.JsonNode
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.partner.core.action.ActionPerformer
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum
import ru.yandex.partner.core.entity.block.actions.all.BlockActionDelete
import ru.yandex.partner.core.entity.block.model.RtbBlock
import ru.yandex.partner.core.entity.block.multistate.RtbBlockMultistateGraph

@Component
class RtbDeleteFromAdfoxFactory @Autowired constructor(
    private val rtbBlockMultistateGraph: RtbBlockMultistateGraph,
    private val actionPerformer: ActionPerformer,
    private val errorHandler: BlockActionErrorHandler<RtbBlock>,
    private val rtbBlockSetNeedUpdateFactory: RtbBlockSetNeedUpdateFactory,
    private val rtbBlockStopFactory: RtbBlockStopFactory
) :
        CustomPayloadActionFactory<RtbBlock,
            BlockActionDelete<RtbBlock>>(BlockActionsEnum.DELETE_FROM_ADFOX, rtbBlockMultistateGraph) {

    override fun createAction(ids: List<Long>, payload: JsonNode?): BlockActionDelete<RtbBlock> {
        return RtbBlockActionDelete(
            actionConfiguration,
            name,
            ids,
            rtbBlockSetNeedUpdateFactory,
            rtbBlockStopFactory,
            rtbBlockMultistateGraph,
            actionPerformer,
            errorHandler
        )
    }

    override fun getName(): String {
        return BlockActionsEnum.DELETE_FROM_ADFOX.actionName
    }

    override fun getModelClass(): Class<RtbBlock> {
        return RtbBlock::class.java
    }
}
