package ru.yandex.partner.core.entity.block.actions.rtb.internal;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.configuration.annotation.TransactionWithFallbackScope;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionType;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.factories.BlockActionRestoreWithPageFactory;
import ru.yandex.partner.core.entity.block.actions.all.factories.BlockMultistateActionFactory;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@Configuration
public class InternalRtbActionsConfiguration {

    private final MultistateGraph<InternalRtbBlock, BlockStateFlag> multistateGraph;
    private final ActionPerformer actionPerformer;
    private final ActionErrorHandler<InternalRtbBlock> actionErrorHandler;

    public InternalRtbActionsConfiguration(MultistateGraph<InternalRtbBlock, BlockStateFlag> multistateGraph,
                                           ActionPerformer actionPerformer,
                                           ActionErrorHandler<InternalRtbBlock> actionErrorHandler) {
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.actionErrorHandler = actionErrorHandler;
    }

    @BlockActionType(BlockActionsEnum.DELETE_WITH_PAGE)
    @Bean
    BlockMultistateActionFactory<InternalRtbBlock> internalRtbDeleteWithPageActionFactory() {
        return simpleActionFactory(BlockActionsEnum.DELETE_WITH_PAGE);
    }

    @BlockActionType(BlockActionsEnum.RESTORE_WITH_PAGE)
    @Bean
    BlockActionRestoreWithPageFactory<InternalRtbBlock> internalRtbRestoreWithPageActionFactory(
            InternalRtbBlockStartFactory internalRtbBlockStartFactory
    ) {
        return new BlockActionRestoreWithPageFactory<>(
                InternalRtbBlock.class,
                multistateGraph,
                actionPerformer,
                actionErrorHandler,
                internalRtbBlockStartFactory
        );
    }


    @BlockActionType(BlockActionsEnum.SET_CHECK_STATISTICS)
    @Bean
    BlockMultistateActionFactory<InternalRtbBlock> internalRtbSetCheckStatisticsActionFactory() {
        return simpleActionFactory(BlockActionsEnum.SET_CHECK_STATISTICS);
    }

    @BlockActionType(BlockActionsEnum.RESET_CHECK_STATISTICS)
    @Bean
    BlockMultistateActionFactory<InternalRtbBlock> internalRtbResetCheckStatisticsActionFactory() {
        return simpleActionFactory(BlockActionsEnum.RESET_CHECK_STATISTICS);
    }

    @BlockActionType(BlockActionsEnum.START_UPDATE)
    @Bean
    BlockMultistateActionFactory<InternalRtbBlock> internalRtbStartUpdateActionFactory() {
        return simpleActionFactory(BlockActionsEnum.START_UPDATE, false);
    }

    @BlockActionType(BlockActionsEnum.STOP_UPDATE)
    @Bean
    BlockMultistateActionFactory<InternalRtbBlock> internalRtbStopUpdateActionFactory() {
        return simpleActionFactory(BlockActionsEnum.STOP_UPDATE, false);
    }

    @TransactionWithFallbackScope
    @Bean
    BlockActionErrorHandler<InternalRtbBlock> internalRtbBlockActionErrorHandler() {
        return new BlockActionErrorHandler<InternalRtbBlock>();
    }

    private BlockMultistateActionFactory<InternalRtbBlock> simpleActionFactory(BlockActionsEnum action) {
        return simpleActionFactory(action, true);
    }

    private BlockMultistateActionFactory<InternalRtbBlock>
    simpleActionFactory(BlockActionsEnum action, boolean writeActionLog) {

        return new BlockMultistateActionFactory<>(
                InternalRtbBlock.class,
                action,
                multistateGraph,
                actionPerformer,
                actionErrorHandler,
                writeActionLog
        );
    }
}
