package ru.yandex.partner.core.entity.block.actions.rtb.internal;

import java.util.function.Function;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.log.InternalRtbBlockActionsLogger;
import ru.yandex.partner.core.entity.block.InternalRtbCopyMapper;
import ru.yandex.partner.core.entity.block.actions.BlockActionContext;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.service.BlockService;
import ru.yandex.partner.core.entity.block.service.BlockUpdateOperationFactory;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class InternalRtbBlockActionContext extends BlockActionContext<InternalRtbBlock> {

    @Autowired
    public InternalRtbBlockActionContext(InternalRtbBlockActionsLogger actionsLogger,
                                         ActionErrorHandler<InternalRtbBlock> errorHandler,
                                         BlockService blockService,
                                         InternalRtbCopyMapper internalRtbCopyMapper,
                                         BlockUpdateOperationFactory blockUpdateOperationFactory) {
        super(actionsLogger, errorHandler, blockService, internalRtbCopyMapper, blockUpdateOperationFactory);
    }

    @Override
    public Class<InternalRtbBlock> getEntityClass() {
        return InternalRtbBlock.class;
    }

    @Override
    protected Function<Long, BaseBlock> getModelStubCreator() {
        return id -> new InternalRtbBlock().withId(id);
    }
}
