package ru.yandex.partner.core.entity.block.actions.rtb.internal;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.block.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.action.factories.block.ActionStopFactory;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionDelete;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@ParametersAreNonnullByDefault
public class InternalRtbBlockActionDelete extends BlockActionDelete<InternalRtbBlock> {

    @SuppressWarnings("checkstyle:parameternumber")
    public InternalRtbBlockActionDelete(ActionConfiguration<InternalRtbBlock, ?> parentFactory,
                                String actionName,
                                Collection<Long> containerIds,
                                ActionSetNeedUpdateFactory<InternalRtbBlock, BlockStateFlag> actionSetNeedUpdateFactory,
                                ActionStopFactory<InternalRtbBlock, BlockStateFlag> blockStopFactory,
                                MultistateGraph<InternalRtbBlock, BlockStateFlag> multistateGraph,
                                ActionPerformer actionPerformer,
                                ActionErrorHandler<InternalRtbBlock> actionErrorHandler) {
        super(parentFactory, actionName, containerIds, actionSetNeedUpdateFactory, blockStopFactory, multistateGraph,
                actionPerformer, actionErrorHandler, InternalRtbBlock.class);
    }

    @Override
    protected void reducePagesCount(Map<Long, Long> pageIds) {
        // has no limits
    }
}
