package ru.yandex.partner.core.entity.block.actions.rtb.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.factories.block.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.action.factories.block.ActionStartFactory;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.agreement.service.AgreementChecker;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionRestore;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;
import ru.yandex.partner.libs.rbac.userrole.UserRoleService;

@ParametersAreNonnullByDefault
public class InternalRtbBlockActionRestore extends BlockActionRestore<InternalRtbBlock, InternalContextPage> {

    @SuppressWarnings("checkstyle:parameternumber")
    public InternalRtbBlockActionRestore(
            ActionConfiguration<InternalRtbBlock, ?> parentFactory,
            Collection<Long> containerIds,
            String actionName,
            ActionSetNeedUpdateFactory<InternalRtbBlock, BlockStateFlag> actionSetNeedUpdateFactory,
            ActionStartFactory<InternalRtbBlock, BlockStateFlag> actionStartFactory,
            MultistateGraph<InternalRtbBlock, BlockStateFlag> multistateGraph,
            ActionPerformer actionPerformer, ActionErrorHandler<InternalRtbBlock> actionErrorHandler,
            AgreementChecker agreementChecker,
            UserRoleService userRoleService,
            ActionUserIdContext actionUserIdContext) {

        super(parentFactory, containerIds, actionName, actionSetNeedUpdateFactory, actionStartFactory, multistateGraph,
                actionPerformer, actionErrorHandler, InternalRtbBlock.class, agreementChecker,
                userRoleService, actionUserIdContext);

    }

    @Override
    protected void incrementPagesCount(Map<Long, Long> pageIds) {
        // have no limits
    }

    @Override
    protected Map<Long, InternalContextPage> getPages(Set<InternalRtbBlock> blocks) {
        return StreamEx.of(blocks).toMap(InternalRtbBlock::getPageId, InternalRtbBlock::getCampaign);
    }

    @Override
    protected List<BlockType> getBlockTypesForChecker() {
        return List.of(BlockType.INTERNAL_CONTEXT_ON_SITE_RTB);
    }
}
