package ru.yandex.partner.core.entity.block.actions.rtb.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.action.ActionContextFacade;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionAdd;
import ru.yandex.partner.core.entity.block.actions.all.factories.BlockAddActionFactory;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.entity.page.model.PageWithBlocksLimit;
import ru.yandex.partner.core.service.entitymanager.EntityManager;

@Component
public class InternalRtbBlockAddFactory
        extends CustomPayloadActionFactory<InternalRtbBlock, BlockActionAdd<InternalRtbBlock>>
        implements BlockAddActionFactory<InternalRtbBlock> {

    private final InternalRtbBlockMultistateGraph multistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<InternalRtbBlock> actionErrorHandler;
    private final ObjectMapper objectMapper;
    private final InternalRtbBlockSetNeedUpdateFactory actionSetNeedUpdateFactory;
    private final InternalRtbBlockStartFactory blockStartFactory;
    private final EntityManager entityManager;

    @SuppressWarnings("ParameterNumber")
    @Autowired
    public InternalRtbBlockAddFactory(
            InternalRtbBlockMultistateGraph multistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<InternalRtbBlock> actionErrorHandler,
            ObjectMapper objectMapper,
            InternalRtbBlockSetNeedUpdateFactory actionSetNeedUpdateFactory,
            InternalRtbBlockStartFactory blockStartFactory, EntityManager entityManager) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.ADD, multistateGraph));
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.actionErrorHandler = actionErrorHandler;
        this.objectMapper = objectMapper;
        this.actionSetNeedUpdateFactory = actionSetNeedUpdateFactory;
        this.blockStartFactory = blockStartFactory;
        this.entityManager = entityManager;
    }

    @Override
    public String getName() {
        return BlockActionsEnum.ADD.getActionName();
    }

    @Override
    public BlockActionAdd<InternalRtbBlock> createAction(
            Map<Long, InternalRtbBlock> addedModels,
            Map<Long, Set<ModelProperty<? super InternalRtbBlock, ?>>> addedProps
    ) {
        return new BlockActionAdd<>(
                getActionConfiguration(),
                getName(),
                addedModels,
                addedProps,
                multistateGraph,
                actionPerformer,
                actionErrorHandler,
                objectMapper,
                InternalRtbBlock.class,
                actionSetNeedUpdateFactory,
                blockStartFactory,
                entityManager, this::incBlocksCount);
    }

    @Override
    public BlockActionAdd<InternalRtbBlock> createAction(List<Long> ids, JsonNode payload) {
        throw new UnsupportedOperationException("InternalRtbBlockAddFactory#createAction");
    }

    @Override
    public Class<InternalRtbBlock> getModelClass() {
        return InternalRtbBlock.class;
    }

    private void incBlocksCount(Map<Long, Long> pageIds, ActionContextFacade actionContextFacade) {
        var pageContainers = actionContextFacade.getActionContext(InternalContextPage.class)
                .getContainers(
                        pageIds.keySet(),
                        Set.of(PageWithBlocksLimit.BLOCKS_COUNT, BasePage.ID),
                        true
                );
        pageContainers.forEach(it ->
                it.changeProperty(PageWithBlocksLimit.BLOCKS_COUNT,
                        it.getItem().getBlocksCount() + pageIds.get(it.getItem().getId()))
        );
    }
}

