package ru.yandex.partner.core.entity.block.actions.rtb.internal;

import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.factories.BlockDuplicateFactory;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.block.service.BlockAddService;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;

@Component
public class InternalRtbBlockDuplicateFactory extends BlockDuplicateFactory<InternalRtbBlock> {

    @Autowired
    public InternalRtbBlockDuplicateFactory(
            InternalRtbBlockMultistateGraph multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<InternalRtbBlock> actionErrorHandler,
            BlockAddService<BlockWithMultistate> rtbBlockBlockAddService
    ) {
        super(
                new SmartActionConfigurationFactory<>(BlockActionsEnum.DUPLICATE,
                        multistateGraph,
                        InternalRtbBlock.allModelProperties().stream()
                                .map(mp -> (ModelProperty<? super InternalRtbBlock, ?>) mp)
                                .collect(Collectors.toList())
                ),
                multistateGraph,
                actionPerformer,
                actionErrorHandler,
                InternalRtbBlock.class,
                InternalContextPage.class,
                rtbBlockBlockAddService
        );
    }
}
