package ru.yandex.partner.core.entity.block.actions.rtb.internal;

import java.util.Collection;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.ModelPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.IncomingFields;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionEdit;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.block.service.type.update.BlockUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.entity.block.service.validation.type.BlockValidationTypeSupportFacade;

@Component
public class InternalRtbBlockEditFactory
        extends ModelPayloadActionFactory<InternalRtbBlock, BlockActionEdit<InternalRtbBlock>> {

    private final InternalRtbBlockMultistateGraph multistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<InternalRtbBlock> errorHandler;
    private final ObjectMapper objectMapper;
    private final InternalRtbBlockSetNeedUpdateFactory setNeedUpdateFactory;
    private final BlockUpdateOperationTypeSupportFacade blockUpdateOperationTypeSupportFacade;
    private final BlockValidationTypeSupportFacade blockValidationTypeSupportFacade;

    @SuppressWarnings("ParameterNumber")
    @Autowired
    public InternalRtbBlockEditFactory(
            InternalRtbBlockMultistateGraph multistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<InternalRtbBlock> errorHandler,
            InternalRtbBlockSetNeedUpdateFactory setNeedUpdateFactory,
            BlockUpdateOperationTypeSupportFacade blockUpdateOperationTypeSupportFacade,
            ObjectMapper objectMapper, BlockValidationTypeSupportFacade blockValidationTypeSupportFacade) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.EDIT, multistateGraph));

        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.objectMapper = objectMapper;
        this.setNeedUpdateFactory = setNeedUpdateFactory;
        this.blockUpdateOperationTypeSupportFacade = blockUpdateOperationTypeSupportFacade;
        this.blockValidationTypeSupportFacade = blockValidationTypeSupportFacade;
    }

    @Override
    public BlockActionEdit<InternalRtbBlock> createAction(
            Collection<ModelChanges<? super InternalRtbBlock>> modelChanges,
            IncomingFields updatedFields
    ) {
        return new BlockActionEdit<>(
                getActionConfiguration(),
                getName(),
                modelChanges.stream().map(it -> it.castModel(InternalRtbBlock.class)).collect(Collectors.toList()),
                updatedFields,
                multistateGraph,
                actionPerformer,
                errorHandler,
                objectMapper,
                setNeedUpdateFactory,
                blockUpdateOperationTypeSupportFacade,
                InternalRtbBlock.class,
                blockValidationTypeSupportFacade);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.EDIT.getActionName();
    }

    @Override
    public Class<InternalRtbBlock> getModelClass() {
        return InternalRtbBlock.class;
    }
}

