package ru.yandex.partner.core.entity.block.actions.rtb.internal;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.MultistateChangingActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.agreement.service.AgreementChecker;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionRestore;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.rbac.userrole.UserRoleService;

@Component
public class InternalRtbBlockRestoreFactory
        extends CustomPayloadActionFactory<InternalRtbBlock, BlockActionRestore<InternalRtbBlock, InternalContextPage>>
        implements MultistateChangingActionFactory<InternalRtbBlock, BlockStateFlag> {

    private final InternalRtbBlockMultistateGraph multistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<InternalRtbBlock> errorHandler;
    private final InternalRtbBlockSetNeedUpdateFactory blockSetNeedUpdateFactory;
    private final InternalRtbBlockStartFactory blockStartFactory;
    private final AgreementChecker agreementChecker;
    private final UserRoleService userRoleService;
    private final ActionUserIdContext actionUserIdContext;

    @Autowired
    @SuppressWarnings("checkstyle:parameternumber")
    public InternalRtbBlockRestoreFactory(
            InternalRtbBlockMultistateGraph multistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<InternalRtbBlock> errorHandler,
            InternalRtbBlockSetNeedUpdateFactory blockSetNeedUpdateFactory,
            InternalRtbBlockStartFactory blockStartFactory,
            AgreementChecker agreementChecker,
            UserRoleService userRoleService,
            ActionUserIdContext actionUserIdContext
    ) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.RESTORE, multistateGraph));
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.blockSetNeedUpdateFactory = blockSetNeedUpdateFactory;
        this.blockStartFactory = blockStartFactory;
        this.agreementChecker = agreementChecker;
        this.userRoleService = userRoleService;
        this.actionUserIdContext = actionUserIdContext;
    }

    @Override
    public BlockActionRestore<InternalRtbBlock, InternalContextPage> createAction(Collection<Long> ids) {
        return new InternalRtbBlockActionRestore(
                getActionConfiguration(),
                ids,
                getName(),
                blockSetNeedUpdateFactory,
                blockStartFactory,
                multistateGraph,
                actionPerformer,
                errorHandler,
                agreementChecker,
                userRoleService,
                actionUserIdContext);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.RESTORE.getActionName();
    }

    @Override
    public BlockActionRestore<InternalRtbBlock, InternalContextPage> createAction(List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public Class<InternalRtbBlock> getModelClass() {
        return InternalRtbBlock.class;
    }
}
