package ru.yandex.partner.core.entity.block.actions.rtb.internal;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.action.factories.block.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionSetNeedUpdate;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.page.actions.factory.internal.InternalContextPageSetNeedUpdateActionFactory;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;

@Component
public class InternalRtbBlockSetNeedUpdateFactory
        extends CustomPayloadActionFactory<InternalRtbBlock,
        BlockActionSetNeedUpdate<InternalRtbBlock, InternalContextPage>>
        implements ActionSetNeedUpdateFactory<InternalRtbBlock, BlockStateFlag> {

    private final InternalRtbBlockMultistateGraph multistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<InternalRtbBlock> errorHandler;
    private final InternalContextPageSetNeedUpdateActionFactory pageSetNeedUpdateActionFactory;

    @Autowired
    public InternalRtbBlockSetNeedUpdateFactory(
            InternalRtbBlockMultistateGraph multistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<InternalRtbBlock> errorHandler,
            InternalContextPageSetNeedUpdateActionFactory pageSetNeedUpdateActionFactory) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.SET_NEED_UPDATE, multistateGraph));
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.pageSetNeedUpdateActionFactory = pageSetNeedUpdateActionFactory;
    }

    @Override
    public BlockActionSetNeedUpdate<InternalRtbBlock, InternalContextPage> createAction(List<Long> ids,
                                                                                        JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.SET_NEED_UPDATE.getActionName();
    }

    @Override
    public BlockActionSetNeedUpdate<InternalRtbBlock, InternalContextPage> createAction(Collection<Long> ids) {
        return new BlockActionSetNeedUpdate<>(
                getActionConfiguration(),
                getName(),
                ids,
                pageSetNeedUpdateActionFactory,
                multistateGraph,
                actionPerformer,
                errorHandler,
                InternalRtbBlock.class
        );
    }

    @Override
    public Class<InternalRtbBlock> getModelClass() {
        return InternalRtbBlock.class;
    }
}

