package ru.yandex.partner.core.entity.block.actions.rtb.internal;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.action.factories.block.ActionStopFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionStop;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalRtbBlockMultistateGraph;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;

@Component
public class InternalRtbBlockStopFactory
        extends CustomPayloadActionFactory<InternalRtbBlock, BlockActionStop<InternalRtbBlock>>
        implements ActionStopFactory<InternalRtbBlock, BlockStateFlag> {

    private final InternalRtbBlockMultistateGraph multistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<InternalRtbBlock> errorHandler;

    @Autowired
    public InternalRtbBlockStopFactory(InternalRtbBlockMultistateGraph multistateGraph,
                                       ActionPerformer actionPerformer,
                                       BlockActionErrorHandler<InternalRtbBlock> errorHandler) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.STOP, multistateGraph));
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
    }

    @Override
    public BlockActionStop<InternalRtbBlock> createAction(List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.STOP.getActionName();
    }

    @Override
    public BlockActionStop<InternalRtbBlock> createAction(Collection<Long> ids) {
        return new BlockActionStop<>(
                getActionConfiguration(),
                getName(),
                ids,
                multistateGraph,
                actionPerformer,
                errorHandler,
                InternalRtbBlock.class
        );
    }

    @Override
    public Class<InternalRtbBlock> getModelClass() {
        return InternalRtbBlock.class;
    }
}

