package ru.yandex.partner.core.entity.block.actions.rtb.internal;

import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionDelete;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalRtbBlockMultistateGraph;

@Component
public class InternalRtbDeleteFromAdfoxFactory
        extends CustomPayloadActionFactory<InternalRtbBlock, BlockActionDelete<InternalRtbBlock>> {

    private final InternalRtbBlockMultistateGraph multistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<InternalRtbBlock> errorHandler;
    private final InternalRtbBlockSetNeedUpdateFactory blockSetNeedUpdateFactory;
    private final InternalRtbBlockStopFactory blockStopFactory;

    @Autowired
    public InternalRtbDeleteFromAdfoxFactory(InternalRtbBlockMultistateGraph multistateGraph,
                                             ActionPerformer actionPerformer,
                                             BlockActionErrorHandler<InternalRtbBlock> errorHandler,
                                             InternalRtbBlockSetNeedUpdateFactory blockSetNeedUpdateFactory,
                                             InternalRtbBlockStopFactory blockStopFactory) {
        super(BlockActionsEnum.DELETE_FROM_ADFOX, multistateGraph);
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.blockSetNeedUpdateFactory = blockSetNeedUpdateFactory;
        this.blockStopFactory = blockStopFactory;
    }

    @Override
    public String getName() {
        return BlockActionsEnum.DELETE_FROM_ADFOX.getActionName();
    }

    @Override
    public Class<InternalRtbBlock> getModelClass() {
        return InternalRtbBlock.class;
    }

    @Override
    public BlockActionDelete<InternalRtbBlock> createAction(List<Long> ids, JsonNode payload) {
        return new InternalRtbBlockActionDelete(
                getActionConfiguration(),
                getName(),
                ids,
                blockSetNeedUpdateFactory,
                blockStopFactory,
                multistateGraph,
                actionPerformer,
                errorHandler);
    }
}
