package ru.yandex.partner.core.entity.block.actions.rtb.mobile.external;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.configuration.annotation.TransactionWithFallbackScope;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionType;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.factories.BlockActionRestoreWithPageFactory;
import ru.yandex.partner.core.entity.block.actions.all.factories.BlockMultistateActionFactory;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@Configuration
public class MobileRtbActionsConfiguration {
    private final MultistateGraph<MobileRtbBlock, BlockStateFlag> rtbMultistate;
    private final ActionPerformer actionPerformer;
    private final ActionErrorHandler<MobileRtbBlock> actionErrorHandler;

    public MobileRtbActionsConfiguration(
            MultistateGraph<MobileRtbBlock, BlockStateFlag> rtbMultistate,
            ActionPerformer actionPerformer,
            ActionErrorHandler<MobileRtbBlock> actionErrorHandler
    ) {
        this.rtbMultistate = rtbMultistate;
        this.actionPerformer = actionPerformer;
        this.actionErrorHandler = actionErrorHandler;
    }

    @BlockActionType(BlockActionsEnum.DELETE_WITH_PAGE)
    @Bean
    BlockMultistateActionFactory<MobileRtbBlock> mobileRtbDeleteWithPageActionFactory() {
        return simpleActionFactory(BlockActionsEnum.DELETE_WITH_PAGE);
    }

    @BlockActionType(BlockActionsEnum.RESTORE_WITH_PAGE)
    @Bean
    BlockActionRestoreWithPageFactory<MobileRtbBlock> mobileRtbRestoreWithPageActionFactory(
            MobileRtbBlockStartFactory mobileRtbBlockStartFactory
    ) {
        return new BlockActionRestoreWithPageFactory<>(
                MobileRtbBlock.class,
                rtbMultistate,
                actionPerformer,
                actionErrorHandler,
                mobileRtbBlockStartFactory
        );
    }

    @BlockActionType(BlockActionsEnum.RESET_CHECK_STATISTICS)
    @Bean
    BlockMultistateActionFactory<MobileRtbBlock> mobileRtbResetCheckStatisticsActionFactory() {
        return simpleActionFactory(BlockActionsEnum.RESET_CHECK_STATISTICS);
    }

    @BlockActionType(BlockActionsEnum.START_UPDATE)
    @Bean
    BlockMultistateActionFactory<MobileRtbBlock> mobileRtbStartUpdateActionFactory() {
        return simpleActionFactory(BlockActionsEnum.START_UPDATE, false);
    }

    @BlockActionType(BlockActionsEnum.STOP_UPDATE)
    @Bean
    BlockMultistateActionFactory<MobileRtbBlock> mobileRtbStopUpdateActionFactory() {
        return simpleActionFactory(BlockActionsEnum.STOP_UPDATE, false);
    }

    @TransactionWithFallbackScope
    @Bean
    BlockActionErrorHandler<MobileRtbBlock> mobileRtbBlockActionErrorHandler() {
        return new BlockActionErrorHandler<>();
    }

    private BlockMultistateActionFactory<MobileRtbBlock> simpleActionFactory(BlockActionsEnum action) {
        return simpleActionFactory(action, true);
    }

    private BlockMultistateActionFactory<MobileRtbBlock> simpleActionFactory(
            BlockActionsEnum action, boolean writeActionLog) {
        return new BlockMultistateActionFactory<>(
                MobileRtbBlock.class,
                action,
                rtbMultistate,
                actionPerformer,
                actionErrorHandler,
                writeActionLog
        );
    }
}
