package ru.yandex.partner.core.entity.block.actions.rtb.mobile.external;

import java.util.function.Function;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.entity.block.MobileRtbCopyMapper;
import ru.yandex.partner.core.entity.block.actions.BlockActionContext;
import ru.yandex.partner.core.entity.block.actions.log.MobileRtbBlockActionsLogger;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.block.service.BlockService;
import ru.yandex.partner.core.entity.block.service.BlockUpdateOperationFactory;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class MobileRtbBlockActionContext extends BlockActionContext<MobileRtbBlock> {

    @Autowired
    public MobileRtbBlockActionContext(MobileRtbBlockActionsLogger actionsLogger,
                                       ActionErrorHandler<MobileRtbBlock> errorHandler,
                                       BlockService blockService,
                                       MobileRtbCopyMapper mobileRtbCopyMapper,
                                       BlockUpdateOperationFactory blockUpdateOperationFactory) {
        super(actionsLogger, errorHandler, blockService, mobileRtbCopyMapper, blockUpdateOperationFactory);
    }

    @Override
    public Class<MobileRtbBlock> getEntityClass() {
        return MobileRtbBlock.class;
    }

    @Override
    protected Function<Long, BaseBlock> getModelStubCreator() {
        return id -> new MobileRtbBlock().withId(id);
    }
}
