package ru.yandex.partner.core.entity.block.actions.rtb.mobile.external;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionContext;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionModelContainerImpl;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.block.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.action.factories.block.ActionStopFactory;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionDelete;
import ru.yandex.partner.core.entity.block.model.BlockWithPlaceId;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.core.service.adfox.AdfoxService;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@ParametersAreNonnullByDefault
public class MobileRtbBlockActionDelete extends BlockActionDelete<MobileRtbBlock> {

    private final AdfoxService adfoxService;

    @SuppressWarnings("checkstyle:parameternumber")
    public MobileRtbBlockActionDelete(
            ActionConfiguration<MobileRtbBlock, ?> parentFactory,
            String actionName,
            Collection<Long> containerIds,
            ActionSetNeedUpdateFactory<MobileRtbBlock, BlockStateFlag> actionSetNeedUpdateFactory,
            ActionStopFactory<MobileRtbBlock, BlockStateFlag> blockStopFactory,
            MultistateGraph<MobileRtbBlock, BlockStateFlag> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<MobileRtbBlock> actionErrorHandler,
            AdfoxService adfoxService) {
        super(parentFactory, actionName, containerIds, actionSetNeedUpdateFactory, blockStopFactory, multistateGraph,
                actionPerformer, actionErrorHandler, MobileRtbBlock.class);
        this.adfoxService = adfoxService;
    }

    @Override
    protected void reducePagesCount(Map<Long, Long> pageIds) {
        // has no limits
    }

    @Override
    public void onAction(
            ActionContext<MobileRtbBlock, ActionModelContainerImpl<MobileRtbBlock>> context,
            List<ActionModelContainerImpl<MobileRtbBlock>> actionModelContainers
    ) {
        super.onAction(context, actionModelContainers);

        List<Long> placeIds = actionModelContainers.stream()
                .map(ActionModelContainerImpl::getItem)
                .map(MobileRtbBlock::getPlaceId)
                .filter(Objects::nonNull)
                .toList();

        if (!placeIds.isEmpty()) {
            adfoxService.deleteBlock(placeIds);
        }

        actionModelContainers.forEach(container -> {
            container.changeProperty(BlockWithPlaceId.PLACE_ID, null);
        });
    }
}
